#ifndef __J2534_H
#define __J2534_H

#include <stdint.h>

#define MUX_MAX_CHANNELID 	6
#define MUX_MAX_PERIODICMSG 10
#define MUX_MAX_PACKETSIZE 	5120
#define MUX_MAX_SEND_MSG	40
#define MUX_MAX_RECIV_MSG	128

#define MUX_MAX_FILTERID_CAN 16
#define MUX_MAX_FILTERID_J1850 16
#define MUX_MAX_FILTERID_TP20 16
#define MUX_MAX_FILTERID_TP16 16
#define MUX_MAX_FILTERID_UARTE 16
#define MUX_MAX_FILTERID_KLINE 16
#define MUX_MAX_FILTERID_ISO15765 16

//ProtocolID
#define	J1850VPW 					1
#define	J1850PWM					2
#define	ISO9141						3
#define	ISO14230					4
#define	CAN							5
#define	ISO15765					6
#define	SCI_A_ENGINE				7
#define	SCI_A_TRANS					8
#define	SCI_B_ENGINE				9
#define	SCI_B_TRANS					10
#define	J1850VPW_PS					0x8000
#define	J1850PWM_PS					0x8001
#define	ISO9141_PS					0x8002
#define	ISO14230_PS					0x8003
#define	CAN_PS						0x8004
#define	ISO15765_PS					0x8005
#define	J2610_PS					0x8006
#define	SW_ISO15765_PS				0x8007
#define	SW_CAN_PS					0x8008
#define	GM_UART_PS					0x8009
#define	UART_ECHO_BYTE_PS			0x800A
#define	HONDA_DIAGH_PS				0x800B
#define	J1939_PS					0x800C
#define	J1708_PS 					0x800D
#define	TP2_0_PS					0x800E
#define	FT_CAN_PS			 		0x800F
#define	FT_ISO15765_PS		 		0x8010
#define	TP1_6_PS		 			0x8FFE

// IOCTL ID
#define	GET_CONFIG					0x01
#define	SET_CONFIG					0x02
#define	READ_VBATT					0x03
#define	FIVE_BAUD_INIT				0x04
#define	FAST_INIT					0x05
#define	CLEAR_TX_BUFFER				0x07
#define	CLEAR_RX_BUFFER				0x08
#define	CLEAR_PERIODIC_MSGS			0x09
#define	CLEAR_MSG_FILTERS			0x0A
#define	CLEAR_FUNCT_MSG_LOOKUP_TABLE 		0x0B
#define	ADD_TO_FUNCT_MSG_LOOKUP_TABLE		0x0C
#define	DELETE_FROM_FUNCT_MSG_LOOKUP_TABLE	0x0D
#define	READ_PROG_VOLTAGE			0x0E
#define	BUS_ON						0x0F
#define	SW_CAN_HS					0x8000
#define	SW_CAN_NS					0x8001
#define	SET_POLL_RESPONSE			0x8002
#define	BECOME_MASTER				0x8003
#define START_REPEAT_MESSAGE		0x8004
#define QUERY_REPEAT_MESSAGE		0x8005
#define STOP_REPEAT_MESSAGE			0x8006
#define GET_DEVICE_CONFIG			0x8007
#define SET_DEVICE_CONFIG			0x8008
#define PROTECT_J1939_ADDR			0x8009
#define REQUEST_CONNECTION			0x800A
#define TEARDOWN_CONNECTION			0x800B
#define GET_DEVICE_INFO				0x800B
#define GET_PROTOCOL_INFO			0x800C


// Parameter
#define	DATA_RATE					0x01
#define	LOOPBACK					0x03
#define	NODE_ADDRESS				0x04
#define	NETWORK_LINE				0x05
#define	P1_MIN						0x06 // Don't use
#define	P1_MAX						0x07
#define	P2_MIN						0x08 // Don't use
#define	P2_MAX						0x09 // Don't use
#define	P3_MIN						0x0A
#define	P3_MAX						0x0B // Don't use
#define	P4_MIN						0x0C
#define	P4_MAX						0x0D // Don't use
#define	W1							0x0E
#define	W2							0x0F
#define	W3							0x10
#define	W4							0x11
#define	W5							0x12
#define	TIDLE						0x13
#define	TINIL						0x14
#define	TWUP						0x15
#define	PARITY						0x16
#define	BIT_SAMPLE_POINT			0x17
#define	SYNC_JUMP_WIDTH				0x18
#define	W0							0x19
#define	T1_MAX						0x1A
#define	T2_MAX						0x1B
#define	T4_MAX						0x1C
#define	T5_MAX						0x1D
#define	ISO15765_BS					0x1E
#define	ISO15765_STMIN				0x1F
#define	DATA_BITS					0x20
#define	FIVE_BAUD_MOD				0x21
#define	BS_TX						0x22
#define	STMIN_TX					0x23
#define	T3_MAX						0x24
#define	ISO15765_WFT_MAX			0x25
#define	W1_MIN						0x26
#define	W2_MIN						0x27
#define	W3_MIN						0x28
#define	W4_MAX						0x29
#define	N_BR_MIN 					0x2A
#define	ISO15765_PAD_VALUE 			0x2B
#define	N_AS_MAX					0x2C
#define	N_AR_MAX					0x2D
#define	N_BS_MAX					0x2E
#define	N_CR_MAX					0x2F
#define	N_CS_MIN 					0x30
#define	ECHO_PHYSICAL_CHANNEL_TX	0x31

#define CAN_MIXED_FORMAT			0x8000
#define	J1962_PINS	 				0x8001
#define	SW_CAN_HS_DATA_RATE			0x8010
#define	SW_CAN_SPEEDCHANGE_ENABLE	0x8011
#define	SW_CAN_RES_SWITCH			0x8012
#define	ACTIVE_CHANNELS				0x8020
#define	SAMPLE_RATE	 				0x8021
#define	SAMPLES_PER_READING			0x8022
#define	READINGS_PER_MSG			0x8023
#define	AVERAGING_METHOD			0x8024
#define	SAMPLE_RESOLUTION			0x8025
#define	INPUT_RANGE_LOW				0x8026
#define	INPUT_RANGE_HIGH			0x8027
#define	UEB_T0_MIN					0x8028
#define	UEB_T1_MAX					0x8029
#define	UEB_T2_MAX					0x802A
#define	UEB_T3_MAX					0x802B
#define	UEB_T4_MIN					0x802C
#define	UEB_T5_MAX					0x802D
#define	UEB_T6_MAX					0x802E
#define	UEB_T7_MIN					0x802F
#define	UEB_T7_MAX					0x8030
#define	UEB_T9_MIN					0x8031
#define	J1939_PINS					0x803D
#define	J1708_PINS					0x803E
#define	J1939_T1					0x803F
#define	J1939_T2					0x8040
#define	J1939_T3					0x8041
#define	J1939_T4					0x8042
#define	J1939_BRDCST_MIN_DELAY		0x8043
#define	TP2_0_T_BR_INT				0x8044
#define	TP2_0_T_E					0x8045
#define	TP2_0_MNTC					0x8046
#define	TP2_0_T_CTA					0x8047
#define	TP2_0_MNCT					0x8048
#define	TP2_0_MNTB					0x8049
#define	TP2_0_MNT					0x804A
#define	TP2_0_T_Wait				0x804B
#define	TP2_0_T1					0x804C
#define	TP2_0_T3					0x804D
#define	TP2_0_IDENTIFER				0x804E
#define	TP2_0_RXIDPASSIVE			0x804F

// Error IDs
#define STATUS_NOERROR				0x00
#define ERR_NOT_SUPPORTED			0x01
#define ERR_INVALID_CHANNEL_ID		0x02
#define ERR_INVALID_PROTOCOL_ID		0x03
#define ERR_NULL_PARAMETER			0x04
#define ERR_INVALID_IOCTL_VALUE		0x05
#define ERR_INVALID_FLAGS			0x06
#define ERR_FAILED					0x07
#define ERR_DEVICE_NOT_CONNECTED 	0x08
#define ERR_TIMEOUT					0x09
#define ERR_INVALID_MSG				0x0A
#define ERR_INVALID_TIME_INTERVAL	0x0B
#define ERR_EXCEEDED_LIMIT			0x0C
#define ERR_INVALID_MSG_ID			0x0D
#define ERR_DEVICE_IN_USE			0x0E
#define ERR_INVALID_IOCTL_ID 		0x0F
#define ERR_BUFFER_EMPTY 			0x10
#define ERR_BUFFER_FULL				0x11
#define ERR_BUFFER_OVERFLOW			0x12
#define ERR_PIN_INVALID				0x13
#define	ERR_CHANNEL_IN_USE			0x14
#define	ERR_MSG_PROTOCOL_ID			0x15
#define	ERR_INVALID_FILTER_ID		0x16
#define	ERR_NO_FLOW_CONTROL			0x17
#define	ERR_NOT_UNIQUE				0x18
#define ERR_INVALID_BAUDRATE		0x19
#define	ERR_INVALID_DEVICE_ID 		0x1A
#define	ERR_DEVICE_NOT_OPEN			0x1B
#define	ERR_NULL_REQUIRED			0x1C
#define	ERR_FILTER_TYPE_NOT_SUPPORTED 0x1D
#define	ERR_INVALID_IOCTL_PARAM_ID	0x1E
#define	ERR_VOLTAGE_IN_USE			0x1F
#define	ERR_PIN_IN_USE				0x20
#define	ERR_INIT_FAILED				0x21
#define	ERR_OPEN_FAILED				0x22
#define	ERR_BUFFER_TOO_SMALL		0x23
#define	ERR_LOG_CHAN_NOT_ALLOWED	0x24
#define	ERR_SELECT_TYPE_NOT_SUPPORTED 0x25
#define	ERR_CONCURRENT_API_CALL	0x26
#define ERR_ADDRESS_NOT_CLAIMED		0x10000
#define ERR_NO_CONNECTION_ESTABLISHED	0x10001
#define ERR_RESOURCE_IN_USE			0x10002

#define J2534_EXT_ERR_FIVEBAUD_INVADR 	0x500
#define J2534_EXT_ERR_FIVEBAUD_PROTID 	0x501
#define J2534_EXT_ERR_SECACC_PARAM	 	0x502
#define J2534_EXT_ERR_SECACC_LEN	 	0x503
#define J2534_EXT_ERR_INTERNAL			0x504
#define J2534_EXT_ERR_LEN				0x505
#define J2534_EXT_ERR_INVALID_PACKET	0x506
#define J2534_EXT_ERR_CS_PACKET			0x507
#define J2534_EXT_ERR_NUMMSG			0x508
#define J2534_EXT_ERR_MARK				0x509
#define J2534_EXT_ERR_SIGN				0x50A
#define J2534_EXT_ERR_MARK_TIME			0x50B


#define SHORT_TO_GROUND				0xFFFFFFFE
#define VOLTAGE_OFF					0xFFFFFFFF

#define	NO_PARITY					0x0
#define	ODD_PARITY					0x1
#define	EVEN_PARITY					0x2

#define BITS_8						0x00000000
#define BITS_9						0x00000001
// NetworkLine
#define	BUS_NORMAL					0x00000000
#define	BUS_PLUS					0x00000001
#define	BUS_MINUS					0x00000002

//FiveBaudMode
#define	FBM_ISO9141_2_ISO14230_4	0x00000000
#define	FBM_ISO9141_INV_KEYBYTE_2	0x00000001
#define	FBM_ISO9141_INV_ADDR		0x00000002
#define	FBM_ISO9141					0x00000003

// Loopback
#define	DONT_ECHO					0x00000000
#define	ECHO						0x00000001

//SWCAN
#define	DISBLE_SPDCHANGE			0
#define	ENABLE_SPDCHANGE			1

//eCANResSwitch
#define	DISCONNECT_RESISTOR			0
#define	CONNECT_RESISTOR			1
#define	AUTO_RESISTOR				2

//CANMixFormat
#define	CAN_MIXED_FORMAT_OFF		0
#define	CAN_MIXED_FORMAT_ON			1
#define	CAN_MIXED_FORMAT_ALL_FRAMES	2

// Analog averaging
#define	SIMPLE_AVERAGE				0x00000000 // Simple arithmetic mean
#define	MAX_LIMIT_AVERAGE	 		0x00000001 // Choose the biggest value
#define	MIN_LIMIT_AVERAGE	 		0x00000002 // Choose the lowest value
#define	MEDIAN_AVERAGE				0x00000003

// Connect Flag Values
#define	FULL_DUPLEX					(1<<0) //
#define	CAN_29BIT_ID				(1<<8)  // 0 Receive standard CAN ID (11 bit)
											// 1 Receive extended CAN ID (29 bit)
#define	ISO9141_NO_CHECKSUM			(1<<9)  // 0 The interface will generate and append the checksum as defined in ISO 9141-2 and ISO 14230-2 for transmitted messages and verify the checksum for received messages.
											// 1 The interface will not generate and verify the checksum-the entire	message will be treated as data by the interface
#define	CAN_ID_BOTH					(1<<11) // 0 either standard or extended CAN ID types used – CAN ID type defined by bit 8
											// 1 both standard and extended CAN ID types used – if the CAN controller 	allows prioritizing either standard (11 bit) or extended (29 bit) CAN ID's then bit 8 will determine the higher priority ID type
#define	ISO9141_K_LINE_ONLY			(1<<12) // 0 use L-line and K-line for initialization address

// RxStatus definitions
#define RX_NONE						0
#define	TX_MSG_TYPE					(1<<0)
#define	START_OF_MESSAGE			(1<<1)
#define	RX_BREAK					(1<<2)
#define	TX_INDICATION				(1<<3)
#define	ISO15765_PADDING_ERROR		(1<<4)
#define	ERROR_INDICATION			(1<<5)
#define	BUFFER_OVERFLOW				(1<<6)
#define	ISO15765_ADDR_TYPE			(1<<7)
#define TX_FAILED					(1<<9)

#define	SW_CAN_HV_RX				(1<<16)
#define	SW_CAN_HS_RX				(1<<17)
#define	SW_CAN_NS_RX				(1<<18)

#define CONNECTION_ESTABLISHED 		(1<<16)
#define CONNECTION_LOST 			(1<<17)

// TxFlag
#define	FL_NONE 0
#define	FL_ISO15765_NO_TXDONE		(1<<0) // Quantex
#define	FL_ISO15765_FRAME_PAD		(1<<6)
#define	FL_ISO15765_ADDR_TYPE		(1<<7)
#define	FL_CAN_29BIT_ID				(1<<8)
#define	FL_WAIT_P3_MIN_ONLY			(1<<9)
#define	FL_SW_CAN_HV_TX				(1<<10)
#define	FL_SCI_MODE					(1<<22)
#define	FL_SCI_TX_VOLTAGE			(1<<23)


// Filter definitions
#define	PASS_FILTER					0x00000001 //allows matching messages into the receive queue. This filter type is only valid on non-ISO 15765 channels
#define	BLOCK_FILTER				0x00000002 //keeps matching messages out of the receive queue. This filter type is only valid on non-ISO 15765 channels
#define	FLOW_CONTROL_FILTER			0x00000003 //allows matching messages into the receive queue and defines an outgoing flow control message to support the ISO 15765-2 flow control mechanism. This filter type is only valid on ISO 15765 channels.

//ProgVPinNum
#define	Pin_0 						0
#define	Pin_6 						6
#define	Pin_11 						11
#define	Pin_12 						12
#define	Pin_13 						13
#define	Pin_14 						14
#define	Pin_15 						15


// PP is the pin number for the primary signal e.g. ISO K-line CAN-H +V eSCI Tx DIAG-H SAE J1850+...
// SS is the pin number for the secondary signal where a secondary signal is present e.g. ISO L-line CAN-L -V eSCI Rx SAE J1850- ... SS shall equal 0x00 if no secondary pin is required or enabled.

#define	PPSS_NotSet					0x00
#define	PP_1 						0x01
#define	PP_2 						0x02
#define	PP_3 						0x03
#define	PP_6 						0x06
#define	PP_7 						0x07
#define	PP_8 						0x08
#define	PP_9 						0x09
#define	PP_10 						0x0A
#define	PP_11 						0x0B
#define	PP_12 						0x0C
#define	PP_13 						0x0D
#define	PP_14 						0x0E
#define	PP_15 						0x0F

#define SS_1 						0x0100
#define	SS_2 						0x0200
#define	SS_3 						0x0300
#define	SS_6 						0x0600
#define	SS_7 						0x0700
#define	SS_8 						0x0800
#define	SS_9 						0x0900
#define	SS_10 						0x0A00
#define	SS_11 						0x0B00
#define	SS_12 						0x0C00
#define	SS_13 						0x0D00
#define	SS_14 						0x0E00
#define SS_15 						0x0F00

// Msg
typedef struct
{
	uint32_t 	ProtocolID;
	uint32_t	RxStatus;
	uint32_t	TxFlags;
	// Timestamp Received message timestamp (microseconds): For the START_OF_FRAME
	//indication the timestamp is for the start of the first bit of the message. For all other
	//indications and transmit and receive messages the timestamp is the end of the last
	//bit of the message. For all other error indications the timestamp is the time the error
	//is detected.
	uint32_t 	Timestamp;
	uint32_t 	DataSize;
	uint32_t	EDI;
	uint8_t		Data[4128];
} PASSTHRU_MSG, *pPASSTHRU_MSG;


// IOCTL
typedef struct
{
	uint32_t Parameter;
	uint32_t Value;
} SCONFIG, *pSCONFIG;

typedef struct
{
	uint32_t NumOfParams;
	SCONFIG* ConfigPtr;
} SCONFIG_LIST, *pSCONFIG_LIST;

typedef struct
{
	uint32_t NumOfBytes;
	uint8_t *BytePtr;
} SBYTE_ARRAY, *pSBYTE_ARRAY;

typedef struct
{
	uint32_t ProtocolID;
	uint32_t TxFlags;
	uint32_t DataSize;
	uint8_t  Data[12];
} PASSTHRU_PERIODIC_MSG, *pPASSTHRU_PERIODIC_MSG;

typedef struct
{
	uint8_t  Type;
	uint8_t  Len;
	uint8_t  FlowControlMsgData[6];
	uint32_t TxFlags;
	uint8_t  MaskMsgData[12];
	uint8_t  PatternMsgData[12];
} S_FILTER, *pS_FILTER;

typedef struct
{
	uint32_t Parameter; /* name of parameter */
	uint32_t Value; /* value of the parameter */
	uint32_t Supported; /* support for parameter */
} SPARAM, *pSPARAM;

#endif /* __J2534_H */
